//----------------RFID-------------------------------------------------
// Support Tag type
#define    TAG_ISO15693         		'V'
#define    TAG_Tagit	       			'T'
#define    TAG_Icode	        		'I'
#define    TAG_MifareISO14443A  		'M'
#define    TAG_SR176            		'S'
#define    TAG_ISO14443B        		'Z'

typedef struct RFIDStruct
{
	unsigned char TagType[4];
	unsigned int  StartByte;	
	unsigned int  MaxLen;		
	unsigned char Reserve[20];	
}RFIDParameter;

void RFIDReadFormat(RFIDParameter *);
void RFIDWriteFormat(RFIDParameter *);

// Key Type
#define KEYA         1
#define KEYB         2

void SetRFIDSecurityKey(unsigned char TagType, unsigned char *KeyString, unsigned char KeyType);
int GetRFIDSecurityKey(unsigned char TagType, unsigned char *KeyString, unsigned char *KeyType);

void * RFIDVersion(void);
void * RFIDLibVersion(void);

